{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 13.03.98 - 14:51:58 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
{$IFDEF WIN32}
  Windows,
{$ELSE}
  WinTypes,
  WinProcs,
{$ENDIF}
  Messages,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  StdCtrls,
  ExtCtrls,
  MMSystem,
  MMRingBf,
  MMACMCvt,
  MMDSPObj,
  MMTrigg,
  MMWave,
  MMObj,
  MMCstDlg,
  MMDesign,
  MMConect,
  MMGauge,
  MMDIBCv,
  MMSpGram,
  MMHook;
  
type
  TMainForm = class(TForm)
    Connector: TMMConnector;
    MMDesigner1: TMMDesigner;
    Spectrogram: TMMSpectrogram;
    btnStop: TButton;
    btnStart: TButton;
    btnFile: TButton;
    WaveOpenDialog: TMMWaveOpenDialog;
    WaveFile: TMMWaveFile;
    Trigger: TMMTrigger;
    MMPCMConverter1: TMMPCMConverter;
    Gauge: TMMGauge;
    MMRingBuffer1: TMMRingBuffer;
    procedure btnStartClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnFileClick(Sender: TObject);
    procedure TriggerOpen(Sender: TObject);
    procedure TriggerStop(Sender: TObject);
    procedure TriggerBufferReady(Sender: TObject; lpWaveHdr: PWaveHdr);
    procedure SpectrogramMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure SpectrogramMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
  public
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   Trigger.Close;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.btnFileClick(Sender: TObject);
begin
   if WaveOpenDialog.Execute then
   begin
      WaveFile.LoadFromFile(WaveOpenDialog.FileName);
      btnStart.Enabled := True;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.btnStartClick(Sender: TObject);
begin
   if not WaveFile.Wave.Empty then
   begin
      Trigger.BufferSize := Spectrogram.BytesPerSpectrogram;
      Trigger.Start;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.btnStopClick(Sender: TObject);
begin
   Trigger.Close;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.TriggerOpen(Sender: TObject);
begin
   btnStart.Enabled := False;
   btnStop.Enabled := True;
   btnFile.Enabled := False;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.TriggerStop(Sender: TObject);
begin
   Trigger.Close;
   Gauge.Progress := 0;
   btnStart.Enabled := True;
   btnStop.Enabled := False;
   btnFile.Enabled := True;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.TriggerBufferReady(Sender: TObject; lpWaveHdr: PWaveHdr);
begin
   Gauge.Progress := Trunc(WaveFile.Wave.Position*100/WaveFile.Wave.DataSize);
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.SpectrogramMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
   if (trPlay in Trigger.State) then Trigger.Pause;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.SpectrogramMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
   if (trPause in Trigger.State) then Trigger.Restart;
end;

end.
